import React, { useState } from 'react';
// import "./App.css";

function App() {
  const [text, setText] = useState('');
  const [result, setResult] = useState('');

  const handleSubmit = async () => {
    const response = await fetch('http://localhost:5000/predict', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ text })
    });

    const data = await response.json();
    setResult(data.label);
  };

  return (
    <div className="container">
      <div className="card">
        <h1 className="title">Klasifikasi Berita Hoaks</h1>
        <textarea
          placeholder="Masukkan teks berita..."
          value={text}
          onChange={e => setText(e.target.value)}
        ></textarea>
        <button onClick={handleSubmit}>Cek Hasil</button>
        {result && (
          <div className={`result ${result.toLowerCase()}`}>
            Hasil: {result}
          </div>
        )}
      </div>
    </div>
  );
}


export default App;